<?php

use App\Http\Controllers\AccessController;
use App\Http\Controllers\ComponentConfig;
use App\Http\Controllers\ConfigController;
use App\Http\Controllers\HelperController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cookie;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Session;

use function Psy\debug;

Route::get('/', function (
    Request $request,
) {
    return redirect(ConfigController::getPagesErrorLinkConfig());
});

Route::post('/{cscs}', function (
    Request $request,
) {
    return redirect(ConfigController::getPagesErrorLinkConfig());
});

Route::post('/', function (
    Request $request,
) {
    return redirect(ConfigController::getPagesErrorLinkConfig());
});


Route::get('/{index}', function (
    Request $request,
) {
    $page_details = [];
    $index = $request->index;
    Log::channel('history')->info($request->ip());

    if (!is_numeric($index) || !($page_details = ComponentConfig::getPageConfig(intval($index))) || !AccessController::isAllowedRequest($request))
        return redirect(ConfigController::getPagesErrorLinkConfig());

    return view($page_details["page"], [
        'index' => $index,
        'status' => 'success',
        'data' => $request->query(),
        'details' => $page_details,
        'user' => HelperController::getUserLocationDetails($request),
    ]);
});
