<?php

use App\Http\Controllers\AccessController;
use App\Http\Controllers\ComponentConfig;
use App\Http\Controllers\ConfigController;
use App\Http\Controllers\FormatterController;
use App\Http\Controllers\HelperController;
use App\Http\Controllers\TelegramBotController;
use Illuminate\Console\View\Components\Component;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use Symfony\Component\Console\Helper\FormatterHelper;

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});

Route::post('/', function (
    Request $request,
) {
    return redirect(ConfigController::getPagesErrorLinkConfig());;
});


Route::post('/{name}', function (
    Request $request,
) {
    $api_details = [];
    if ($request->name === '' || !($api_details = ComponentConfig::getAPIConfig($request->name)) || !AccessController::isAllowedAPICall($request))
        return redirect(ConfigController::getPagesErrorLinkConfig());
    $message = FormatterController::process($request, $request->name);
    $bot = new TelegramBotController();
    $bot->sendMessage($message);

    return [
        'status' => 'success',
        'name' => $request->name,
        'message' => $request->query(),
    ];
});
