<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class HelperController extends Controller
{
    public static function getUserLocationDetails(Request $request)
    {
        $url = "http://www.geoplugin.net/json.gp?ip=" .  $request->ip();
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        $resp = curl_exec($ch);
        curl_close($ch);
        $details = json_decode($resp, true);

        return [
            'ip' => $details['geoplugin_request'],
            'user_agent' => $request->userAgent(),
            'continent_code' => $details['geoplugin_continentCode'],
            'country_code' => $details['geoplugin_countryCode'],
            'currency_code' => $details['geoplugin_currencyCode'],
            'continent_name' => $details['geoplugin_continentName'],
            'country' => $details['geoplugin_countryName'],
            'region' => $details['geoplugin_regionName'],
            'city' => $details['geoplugin_city'],
            'longitude' => $details['geoplugin_longitude'],
            'latitude' => $details['geoplugin_latitude'],
        ];
    }
}
