<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class ConfigController extends Controller
{
    //*************************************************************** */
    // Google configs
    //*************************************************************** */
    public static function getRecaptchaSiteKeyConfig()
    {
        return env('GOOGLE_RECAPTCHA_V3_SITE_KEY');
    }
    public static function getRecaptchaSecretKeyConfig()
    {
        return env('GOOGLE_RECAPTCHA_V3_SECRET_KEY');
    }
    //*************************************************************** */
    // Telegram configs
    //*************************************************************** */
    public static function getTelegramChatIdConfig()
    {
        return env('TELEGRAM_CHAT_ID');
    }
    public static function getTelegramBotToken()
    {
        return env("TELEGRAM_BOT_TOKEN");
    }
    //*************************************************************** */
    // Host configs
    //*************************************************************** */
    public static function getAPIHostConfig()
    {
        return env('API_HOST');
    }
    public static function getWebHostConfig()
    {
        return env('WEB_HOST');
    }
    //*************************************************************** */
    // Access configs
    //*************************************************************** */
    public static function getAccessCountryISOConfig()
    {
        return env('ACCESS_COUNTRY_ISO');
    }
    //*************************************************************** */
    // Pages configs
    //*************************************************************** */
    public static function getPagesDataConfig()
    {
        return env('PAGES_DATA');
    }
    public static function getPagesNamesConfig()
    {
        return env('PAGES_NAMES');
    }
    public static function getPagesWaitingTimeConfig()
    {
        return env('PAGES_WAITING_TIME');
    }
    public static function getPagesTypeOfWaitingPageConfig()
    {
        return env('PAGES_TYPE_OF_WAITING_PAGE');
    }
    public static function getPagesNumberOfRepetitionsConfig()
    {
        return env('PAGES_NUMBER_OF_REPETITIONS');
    }
    public static function getPagesIsFormsEmptyInRepetitionsConfig()
    {
        return env('PAGES_IS_FORMS_EMPTY_IN_REPETITIONS');
    }
    public static function getPagesGoBackPageNameConfig()
    {
        return env('PAGES_GO_BACK_PAGE_NAME');
    }
    public static function getPagesGoNextPageNameConfig()
    {
        return env('PAGES_GO_NEXT_PAGE_NAME');
    }
    public static function getPagesNavigationPageControlTypeConfig()
    {
        return env('PAGES_NAVIGATION_PAGE_CONTROL_TYPE');
    }
    public static function getPagesSuccessLinkConfig()
    {
        return env('PAGES_SUCCESS_LINK');
    }
    public static function getPagesErrorLinkConfig()
    {
        return env('PAGES_ERROR_LINK');
    }

    public static function getPagesSequenceNamesConfig()
    {
        return env("PAGES_SEQUENCE_NAMES");
    }
    public static function getPagesIsActiveConfig()
    {
        return env("PAGES_IS_ACTIVE");
    }
}
