<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class ComponentConfig extends Controller
{
    public static function getPageConfig($page)
    {
        $pages = explode(',', ConfigController::getPagesSequenceNamesConfig());
        $index = $page;
        if ($index < 0 || $index >= count($pages))
            return false;
        $isAvailable = in_array($page, explode(',', ConfigController::getPagesNamesConfig()));
        // $page = $pages[$index];
        // if (!$isAvailable)
        //     return false;
        $pagesData = explode(',', ConfigController::getPagesDataConfig());
        $pagesWaitingTime = explode(',', ConfigController::getPagesWaitingTimeConfig());
        $pagesTypeOfWaitingPage = explode(',', ConfigController::getPagesTypeOfWaitingPageConfig());
        $pagesNumberOfRepetition = explode(',', ConfigController::getPagesNumberOfRepetitionsConfig());
        $pagesNumberOfRepetition = array_map('intval', $pagesNumberOfRepetition);
        $pagesIsFormsEmptyInRepetitions = explode(',', ConfigController::getPagesIsFormsEmptyInRepetitionsConfig());
        $pagesIsFormsEmptyInRepetitions = array_map('boolval', $pagesIsFormsEmptyInRepetitions);
        $pagesGoBackPageName = explode(',', ConfigController::getPagesGoBackPageNameConfig());
        $pagesGoNextPageName = explode(',', ConfigController::getPagesGoNextPageNameConfig());
        $pagesNavigationPageControlType = explode(',', ConfigController::getPagesNavigationPageControlTypeConfig());
        $pagesIsActiveConfig = explode(',', ConfigController::getPagesIsActiveConfig());

        return [
            'page' => $pages[$index],
            'index' => $index,
            'isFinalPage' => $index == count($pages) - 1,
            "isActive" => $pagesIsActiveConfig[$index],
            'pages' => ConfigController::getPagesNamesConfig(),
            'pagesSequence' => ConfigController::getPagesSequenceNamesConfig(),
            'pagesData' => $pagesData,
            'pagesWaitingTime' => $pagesWaitingTime[$index],
            'pagesTypeOfWaitingPage' => $pagesTypeOfWaitingPage[$index],
            'pagesNumberOfRepetition' => $pagesNumberOfRepetition[$index],
            'pagesIsFormsEmptyInRepetitions' => $pagesIsFormsEmptyInRepetitions[$index],
            'pagesGoBackPageName' => $pagesGoBackPageName[$index],
            'pagesGoNextPageName' => $pagesGoNextPageName[$index],
            'pagesNavigationPageControlType' => $pagesNavigationPageControlType[$index],
            'googleRecaptchaSiteKey' => ConfigController::getRecaptchaSiteKeyConfig(),
            'googleRecaptchaSecretKey' => ConfigController::getRecaptchaSecretKeyConfig(),
            'telegramChatId' => ConfigController::getTelegramChatIdConfig(),
            'telegramBotToken' => ConfigController::getTelegramBotToken(),
            'apiHost' => ConfigController::getAPIHostConfig(),
            'webHost' => ConfigController::getWebHostConfig(),
            'accessCountryISO' => ConfigController::getAccessCountryISOConfig(),
            'errorPageLink' => ConfigController::getPagesErrorLinkConfig(),
            'successPageLink' => ConfigController::getPagesSuccessLinkConfig(),
        ];
    }

    public static function getAPIConfig($page)
    {
        $pages = explode(',', ConfigController::getPagesNamesConfig());
        $index = array_search($page, $pages);
        if ($index === false)
            return false;
        $pagesData = explode(',', ConfigController::getPagesDataConfig());
        $pagesWaitingTime = explode(',', ConfigController::getPagesWaitingTimeConfig());
        $pagesTypeOfWaitingPage = explode(',', ConfigController::getPagesTypeOfWaitingPageConfig());
        $pagesNumberOfRepetition = explode(',', ConfigController::getPagesNumberOfRepetitionsConfig());
        $pagesNumberOfRepetition = array_map('intval', $pagesNumberOfRepetition);
        $pagesIsFormsEmptyInRepetitions = explode(',', ConfigController::getPagesIsFormsEmptyInRepetitionsConfig());
        $pagesIsFormsEmptyInRepetitions = array_map('boolval', $pagesIsFormsEmptyInRepetitions);
        $pagesGoBackPageName = explode(',', ConfigController::getPagesGoBackPageNameConfig());
        $pagesGoNextPageName = explode(',', ConfigController::getPagesGoNextPageNameConfig());
        $pagesNavigationPageControlType = explode(',', ConfigController::getPagesNavigationPageControlTypeConfig());

        return [
            'page' => $page,
            'pages' => ConfigController::getPagesNamesConfig(),
            'pagesData' => $pagesData,
            'pagesWaitingTime' => $pagesWaitingTime[$index],
            'pagesTypeOfWaitingPage' => $pagesTypeOfWaitingPage[$index],
            'pagesNumberOfRepetition' => $pagesNumberOfRepetition[$index],
            'pagesIsFormsEmptyInRepetitions' => $pagesIsFormsEmptyInRepetitions[$index],
            'pagesGoBackPageName' => $pagesGoBackPageName[$index],
            'pagesGoNextPageName' => $pagesGoNextPageName[$index],
            'pagesNavigationPageControlType' => $pagesNavigationPageControlType[$index],
            'googleRecaptchaSiteKey' => ConfigController::getRecaptchaSiteKeyConfig(),
            'googleRecaptchaSecretKey' => ConfigController::getRecaptchaSecretKeyConfig(),
            'telegramChatId' => ConfigController::getTelegramChatIdConfig(),
            'telegramBotToken' => ConfigController::getTelegramBotToken(),
            'apiHost' => ConfigController::getAPIHostConfig(),
            'webHost' => ConfigController::getWebHostConfig(),
            'accessCountryISO' => ConfigController::getAccessCountryISOConfig(),
            'errorPageLink' => ConfigController::getPagesErrorLinkConfig(),
            'successPageLink' => ConfigController::getPagesSuccessLinkConfig(),
        ];
    }
}
